////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define _WIN32_DCOM

#include <ObjBase.H>
#include <CommCtrl.H>
#include <ShlOBJ.H>
#include <StdIO.H>
#include <StdLib.H>
#include <IO.h>
#include <Process.H>        // For C library-safe _beginthreadex,_endthreadex

#include "SQL/Vdi.H"        // Interface declaration
#include "SQL/VdiError.H"   // Error constants

#include "SQL/VdiGuid.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include "SQL.H"
#include "SqlExt.H"
#include "ODBCss.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NSWFL.H"

#include "Headers/Definitions.H"

#include "Headers/Registry.H"

#include "Headers/SQL.H"
#include "Headers/GetSQLData.H"

#include "Headers/Functions.H"
#include "Dialogs/MainDialog.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR CmdLine, int CmdShow)
{
	MainInstance = hInstance;

    if( strlen(CmdLine) > 0)
    {
        if(!GetValues())
            return 0;

        if(!GetHeaderOnly(CmdLine))
            return 0;

        if(!GetFileListOnly(CmdLine))
            return 0;

        strcpy(DialogCaption, CmdLine);

    	DialogBox(MainInstance, MAKEINTRESOURCE(100), NULL, MainDialog);

        if(!SetValues())
            return 0;
    }
    else ErrorMessage(NULL, "No input file name");

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

